/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.container.ContainerModFilter;
import me.desht.modularrouters.container.ContainerSmartFilter;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.ModMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.GuiSyncMessage;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.ModNameCache;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ModFilter
extends SmartFilterItem {
    private static final String NBT_MODS = "Mods";
    public static final int MAX_SIZE = 6;

    @Override
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack) {
        return new ModMatcher(ModFilter.getModList(filterStack));
    }

    public static List<String> getModList(ItemStack filterStack) {
        CompoundTag tag = filterStack.m_41737_("modularrouters");
        if (tag != null) {
            ListTag items = tag.m_128437_(NBT_MODS, 8);
            ArrayList res = Lists.newArrayListWithExpectedSize((int)items.size());
            for (int i = 0; i < items.size(); ++i) {
                res.add(items.m_128778_(i));
            }
            return res;
        }
        return Lists.newArrayList();
    }

    private static void setModList(ItemStack filterStack, List<String> mods) {
        ListTag list = mods.stream().map(StringTag::m_129297_).collect(Collectors.toCollection(ListTag::new));
        filterStack.m_41698_("modularrouters").m_128365_(NBT_MODS, (Tag)list);
    }

    @Override
    public void addExtraInformation(ItemStack stack, List<Component> list) {
        super.addExtraInformation(stack, list);
        if (stack.m_41737_("modularrouters") != null) {
            List<String> l = ModFilter.getModList(stack);
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.modFilter.count", l.size()));
            list.addAll(l.stream().map(ModNameCache::getModName).map(s -> " \u2022 " + ChatFormatting.AQUA + s).map(TextComponent::new).toList());
        } else {
            list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.modFilter.count", 0));
        }
    }

    @Override
    public ContainerSmartFilter createContainer(int windowId, Inventory invPlayer, MFLocator loc) {
        return new ContainerModFilter(windowId, invPlayer, loc);
    }

    @Override
    public GuiSyncMessage onReceiveSettingsMessage(Player player, FilterSettingsMessage message, ItemStack filterStack, ItemStack moduleStack) {
        switch (message.getOp()) {
            case ADD_STRING: {
                String modId = message.getPayload().m_128461_("ModId");
                List<String> l = ModFilter.getModList(filterStack);
                if (l.size() >= 6 || l.contains(modId)) break;
                l.add(modId);
                ModFilter.setModList(filterStack, l);
                return new GuiSyncMessage(filterStack);
            }
            case REMOVE_AT: {
                int pos = message.getPayload().m_128451_("Pos");
                List<String> l = ModFilter.getModList(filterStack);
                if (pos < 0 || pos >= l.size()) break;
                l.remove(pos);
                ModFilter.setModList(filterStack, l);
                return new GuiSyncMessage(filterStack);
            }
            default: {
                ModularRouters.LOGGER.warn("received unexpected message type " + message.getOp() + " for " + filterStack);
            }
        }
        return null;
    }

    @Override
    public int getSize(ItemStack filterStack) {
        CompoundTag tag = filterStack.m_41737_("modularrouters");
        return tag != null ? tag.m_128437_(NBT_MODS, 8).size() : 0;
    }
}

